import pandas as pd
from matplotlib import pyplot as plt

plt.style.use("fivethirtyeight")

data = pd.read_csv("data.csv")
ages = data['Age']
dev_salaries = data['All_Devs']
py_salaries = data['Python']
js_salaries = data['JavaScript']
# overall median salary = 57287
overall_median = 57287

plt.figure(1)
plt.plot(ages, dev_salaries, color="#444444",
            linestyle="--", label="All Devs")
plt.plot(ages, py_salaries, label="Python")
# fill area under python
# y2 is the conditional treshold. without it we fill from 0 up to python salaries
# alpha is opacity
# where = specify where to fill
# interpolate = make sure intersectons don't get clipped

# fill above
plt.fill_between(ages, py_salaries, alpha=0.25, y2=overall_median,
                 where=(py_salaries > overall_median),
                 interpolate=True)
# fill below
plt.fill_between(ages, py_salaries, alpha=0.25, y2=overall_median,
                 where=(py_salaries <= overall_median),
                 interpolate=True, color='red')


plt.legend()

plt.title("Median Salary (USD) by Age")
plt.xlabel("Ages")
plt.ylabel("Median salary (USD)")

plt.tight_layout()

plt.figure(2)
plt.plot(ages, dev_salaries, color="#444444",
            linestyle="--", label="All Devs")
plt.plot(ages, py_salaries, label="Python")
# fill area under python
# y2 is the conditional treshold. without it we fill from 0 up to python salaries
# alpha is opacity
# where = specify where to fill
# interpolate = make sure intersectons don't get clipped

#label the filled sections

# fill above
plt.fill_between(ages, py_salaries, alpha=0.25, y2=dev_salaries,
                 where=(py_salaries > dev_salaries),
                 interpolate=True, label="Above median")
# fill below
plt.fill_between(ages, py_salaries, alpha=0.25, y2=dev_salaries,
                 where=(py_salaries <= dev_salaries),
                 interpolate=True, color='red', label="Below average")




plt.legend()

plt.title("Median Salary (USD) by Age")
plt.xlabel("Ages")
plt.ylabel("Median salary (USD)")

plt.tight_layout()
plt.show()

